<?php
// license_server/admin/index.php
session_start();
require __DIR__ . '/../license_db.php';
require __DIR__ . '/admin_config.php';

// IP allowlist (optional)
if (!empty(ADMIN_ALLOW_IPS) && !in_array($_SERVER['REMOTE_ADDR'] ?? '', ADMIN_ALLOW_IPS, true)) {
  http_response_code(403); echo "Forbidden"; exit;
}

function csrf_token() {
  if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['csrf'];
}
function check_csrf() {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ok = isset($_POST['csrf']) && hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf']);
    if (!$ok) { http_response_code(400); echo "Bad CSRF"; exit; }
  }
}
function is_logged_in() { return !empty($_SESSION['is_admin']); }
function login($u, $p) {
  if ($u === ADMIN_USER && password_verify($p, ADMIN_PASS_HASH)) {
    $_SESSION['is_admin'] = true; return true;
  }
  return false;
}
function logout() { unset($_SESSION['is_admin']); }

check_csrf();

// Logout
if (isset($_POST['action']) && $_POST['action']==='logout') { logout(); header('Location: ./'); exit; }

// Login
$login_error = null;
if (isset($_POST['action']) && $_POST['action']==='login') {
  if (!login(trim($_POST['user'] ?? ''), (string)($_POST['pass'] ?? ''))) {
    $login_error = "Invalid credentials";
  } else {
    header('Location: ./'); exit;
  }
}

// Require auth for below
if (!is_logged_in()):
?>
<!doctype html>
<html><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>License Admin — Login</title>
<style>
body{background:#0b0f15;color:#e5eef7;font:16px/1.6 system-ui;margin:0;display:flex;min-height:100vh;align-items:center;justify-content:center}
.card{background:#0e1117;border:1px solid rgba(255,255,255,.08);border-radius:14px;padding:24px;max-width:420px;width:92%}
h1{margin:0 0 12px;font-size:22px}
input,button{width:100%;padding:12px;border-radius:10px;border:1px solid rgba(255,255,255,.12);background:#0f1320;color:#fff;margin:8px 0}
button{background:#6ea8fe;border-color:#6ea8fe;cursor:pointer}
.alert{background:#1d2433;border-left:4px solid #e06c75;padding:10px;border-radius:8px;margin:8px 0}
</style>
</head><body>
  <form class="card" method="post">
    <h1>License Admin</h1>
    <?php if($login_error): ?><div class="alert"><?=htmlspecialchars($login_error)?></div><?php endif; ?>
    <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
    <input type="hidden" name="action" value="login">
    <input name="user" placeholder="Username" autocomplete="username" required>
    <input name="pass" type="password" placeholder="Password" autocomplete="current-password" required>
    <button type="submit">Sign in</button>
  </form>
</body></html>
<?php
exit; endif;

// Handle actions (CRUD)
$notice = null;
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $act = $_POST['action'] ?? '';
  try {
    if ($act === 'add') {
      $purchase = trim($_POST['purchase_code'] ?? '');
      $product  = trim($_POST['product_slug'] ?? 'final-space');
      $status   = in_array($_POST['status'] ?? 'active', ['active','blocked'], true) ? $_POST['status'] : 'active';
      if ($purchase==='') throw new Exception('Purchase code required');
      $stmt = $pdo->prepare('INSERT INTO licenses (purchase_code, product_slug, status) VALUES (?,?,?)');
      $stmt->execute([$purchase, $product, $status]);
      $notice = "License added.";
    } elseif ($act === 'status') {
      $purchase = trim($_POST['purchase_code'] ?? '');
      $status   = in_array($_POST['status'] ?? 'active', ['active','blocked'], true) ? $_POST['status'] : 'active';
      $stmt = $pdo->prepare('UPDATE licenses SET status=? WHERE purchase_code=?');
      $stmt->execute([$status, $purchase]);
      $notice = "Status updated.";
    } elseif ($act === 'reset') {
      $purchase = trim($_POST['purchase_code'] ?? '');
      $stmt = $pdo->prepare('UPDATE licenses SET bound_domain=NULL WHERE purchase_code=?');
      $stmt->execute([$purchase]);
      $notice = "Domain reset.";
    } elseif ($act === 'delete') {
      $purchase = trim($_POST['purchase_code'] ?? '');
      $stmt = $pdo->prepare('DELETE FROM licenses WHERE purchase_code=?');
      $stmt->execute([$purchase]);
      $notice = "License deleted.";
    }
  } catch (Throwable $e) {
    $notice = "Error: " . $e->getMessage();
  }
}

// Fetch list with search/pagination
$q = trim($_GET['q'] ?? '');
$page = max(1, (int)($_GET['page'] ?? 1));
$limit = 50;
$offset = ($page-1)*$limit;

$where = '';
$params = [];
if ($q !== '') {
  $where = 'WHERE purchase_code LIKE ?';
  $params[] = '%' . $q . '%';
}

$total = 0;
$stmt = $pdo->prepare("SELECT COUNT(*) FROM licenses $where");
$stmt->execute($params);
$total = (int)$stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT * FROM licenses $where ORDER BY id DESC LIMIT $limit OFFSET $offset");
$stmt->execute($params);
$rows = $stmt->fetchAll();

$pages = max(1, (int)ceil($total / $limit));

// CSV export
if (isset($_GET['export']) && $_GET['export']==='csv') {
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename="licenses.csv"');
  $out = fopen('php://output', 'w');
  fputcsv($out, ['id','purchase_code','product_slug','status','bound_domain','activations','last_seen','created_at']);
  foreach ($rows as $r) fputcsv($out, [$r['id'],$r['purchase_code'],$r['product_slug'],$r['status'],$r['bound_domain'],$r['activations'],$r['last_seen'],$r['created_at']]);
  fclose($out);
  exit;
}
?>
<!doctype html>
<html><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>License Admin</title>
<style>
:root{--bg:#0b0f15;--card:#0e1117;--text:#e5eef7;--muted:#9fb3c8;--accent:#6ea8fe;--good:#4caf50;--bad:#e06c75}
*{box-sizing:border-box}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui;margin:0}
.wrap{max-width:1100px;margin:30px auto;padding:0 16px}
h1{font-size:22px;margin:0 0 12px}
.card{background:var(--card);border:1px solid rgba(255,255,255,.08);border-radius:14px;padding:16px;margin:12px 0}
input,select,button{padding:10px;border-radius:10px;border:1px solid rgba(255,255,255,.12);background:#0f1320;color:#fff}
button{cursor:pointer;background:var(--accent);border-color:var(--accent)}
.table{width:100%;border-collapse:collapse}
.table th,.table td{padding:8px;border-bottom:1px solid rgba(255,255,255,.08);font-size:14px}
.badge{padding:4px 8px;border-radius:99px;font-size:12px}
.badge.active{background:rgba(76,175,80,.2);border:1px solid rgba(76,175,80,.4)}
.badge.blocked{background:rgba(224,108,117,.2);border:1px solid rgba(224,108,117,.4)}
.row{display:flex;gap:10px;flex-wrap:wrap}
.grow{flex:1}
.alert{background:#1d2433;border-left:4px solid var(--accent);padding:10px;border-radius:8px;margin:8px 0}
.actions form{display:inline}
.pagination a{color:#fff;margin-right:6px;text-decoration:none;padding:4px 8px;border:1px solid rgba(255,255,255,.15);border-radius:8px}
.pagination .current{background:var(--accent);border-color:var(--accent)}
.topbar{display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap}
</style>
</head><body>
<div class="wrap">
  <div class="topbar">
    <h1>License Admin</h1>
    <form method="post">
      <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
      <input type="hidden" name="action" value="logout">
      <button>Logout</button>
    </form>
  </div>

  <?php if($notice): ?><div class="alert"><?=htmlspecialchars($notice)?></div><?php endif; ?>

  <div class="card">
    <form class="row" method="get">
      <input class="grow" name="q" placeholder="Search purchase code…" value="<?=htmlspecialchars($q)?>">
      <button>Search</button>
      <a class="button" style="padding:10px 12px;border:1px solid rgba(255,255,255,.15);border-radius:10px;text-decoration:none" href="?q=<?=urlencode($q)?>&export=csv">Export CSV</a>
    </form>
  </div>

  <div class="card">
    <h3 style="margin:0 0 10px">Add License</h3>
    <form class="row" method="post">
      <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
      <input type="hidden" name="action" value="add">
      <input name="purchase_code" placeholder="Purchase code (unique)" required class="grow">
      <input name="product_slug"  placeholder="Product slug" value="final-space">
      <select name="status">
        <option value="active">active</option>
        <option value="blocked">blocked</option>
      </select>
      <button>Add</button>
    </form>
  </div>

  <div class="card">
    <table class="table">
      <thead>
        <tr><th>ID</th><th>Purchase Code</th><th>Product</th><th>Status</th><th>Bound Domain</th><th>Seen</th><th>Actions</th></tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= htmlspecialchars($r['purchase_code']) ?></td>
          <td><?= htmlspecialchars($r['product_slug']) ?></td>
          <td><span class="badge <?= $r['status']==='active'?'active':'blocked' ?>"><?= htmlspecialchars($r['status']) ?></span></td>
          <td><?= htmlspecialchars($r['bound_domain'] ?? '') ?></td>
          <td><?= htmlspecialchars($r['last_seen'] ?? '') ?></td>
          <td class="actions">
            <form method="post" style="display:inline">
              <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
              <input type="hidden" name="action" value="status">
              <input type="hidden" name="purchase_code" value="<?=htmlspecialchars($r['purchase_code'])?>">
              <input type="hidden" name="status" value="<?= $r['status']==='active'?'blocked':'active' ?>">
              <button><?= $r['status']==='active'?'Block':'Activate' ?></button>
            </form>
            <form method="post" style="display:inline" onsubmit="return confirm('Reset bound domain?')">
              <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
              <input type="hidden" name="action" value="reset">
              <input type="hidden" name="purchase_code" value="<?=htmlspecialchars($r['purchase_code'])?>">
              <button>Reset Domain</button>
            </form>
            <form method="post" style="display:inline" onsubmit="return confirm('Delete this license?')">
              <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="purchase_code" value="<?=htmlspecialchars($r['purchase_code'])?>">
              <button style="background:#e06c75;border-color:#e06c75">Delete</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <div class="pagination" style="margin-top:10px">
      <?php for($i=1;$i<=$pages;$i++): ?>
        <?php if($i===$page): ?>
          <span class="current"><?= $i ?></span>
        <?php else: ?>
          <a href="?q=<?=urlencode($q)?>&page=<?=$i?>"><?= $i ?></a>
        <?php endif; ?>
      <?php endfor; ?>
    </div>
  </div>
</div>
</body></html>
